/*
 * Zero-Clause BSD
 *
 * Permission to use, copy, modify, and/or distribute this software for any purpose with or without fee is hereby granted.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

//#undef _WINDOWS
//#undef WIN32

#if ((defined _WINDOWS) || (defined WIN32) || (defined WIN64))
    #include <Windows.h>    // Standard windows includes
#endif // ((defined _WINDOWS) || (defined WIN32) || (defined WIN64))
#include "..\ThirdPartyComponent5V.h"   // Me self...
#include <wchar.h>          // wcsnlen_s(), wcsncpy_s(), swprintf_s()
#include <string.h>         // strncpy_s()
#include <assert.h>         // assert()

// ------------------------------------------------------------------------------------------------------
// Well known TETRA layer and MSC arrow drawimg
static const wchar_t *g_pstrLayerLMac                   = L"LMac";                      // |           |             |         |         |          |<- LMAC ->|
static const wchar_t *g_pstrLayerUMac                   = L"UMac";                      // |           |             |         |         |<- UMAC ->|          |
static const wchar_t *g_pstrLayerLlc                    = L"LLC";                       // |           |             |         |<- LLC ->|          |          |
static const wchar_t *g_pstrLayerMle                    = L"MLE";                       // |           |             |<- MLE ->|         |          |          |
static const wchar_t *g_pstrLayerMle_Llc                = L"MLE,LLC";                   // |           |             |<--- MLE 2 LLC --->|          |          |
static const wchar_t *g_pstrLayerMmCmce                 = L"MM/CMCE";                   // |           |<- MM/CMCE ->|         |         |          |          |
static const wchar_t *g_pstrLayerTlSdsSndcpSs           = L"TL-SDS/SNDCP/SS";           // |<- SDS.. ->|             |         |         |          |          |
static const wchar_t *g_pstrLayerTlSdsSndcpSs_MmCmce    = L"TL-SDS/SNDCP/SS,MM/CMCE";   // |<--- SDS.. 2 MM/CMCE --->|         |         |          |          |
// ------------------------------------------------------------------------------------------------------

// ------------------------------------------------------------------------------------------------------
#if !((defined _WINDOWS) || (defined WIN32) || (defined WIN64))
    // Define POSIX versions
    #define wcsnlen_s           wcsnlen
    #define wcsncpy_s           wcsncpy
    #define strncpy_s           strncpy
    #define swprintf_s          swprintf
#endif // !((defined _WINDOWS) || (defined WIN32) || (defined WIN64))

// Macros and function for secure add text to a buffer
#ifndef min
    #define __Sec_Min( a, b )                                       (((a) < (b)) ? (a) : (b))
#else  // min
    #define __Sec_Min                                               min
#endif // min
#ifndef max
    #define __Sec_Max( a, b )                                       (((a) > (b)) ? (a) : (b))
#else  // min
    #define __Sec_Max                                               max
#endif // min

// Clean string
#define __Sec_Empty( sDestString )                                  (sDestString)[0] = 0

// Size of the string
#define __Sec_sizeof( sDestString )                                 ((size_t)sizeof(sDestString)/(size_t)sizeof((sDestString)[0]))
#define __Sec_sizeofN( sDestString, nMaxLength )                    __Sec_Min(__Sec_sizeof(sDestString), nMaxLength)

// Force to terminate string
#define __Sec_CloseN( sDestString, nMaxLength )                     sDestString[__Sec_Max(__Sec_sizeofN(sDestString,nMaxLength),1)-1] = 0;

// Give pack string length
#define __Sec_Strnlen( sDestString, nMaxLength )                    wcsnlen_s( sDestString, __Sec_sizeofN(sDestString, nMaxLength) )

// Give back remaining string length
#define __Sec_Remaining_strlen( sDestString, nMaxLength )           (__Sec_sizeofN(sDestString, nMaxLength) - __Sec_Strnlen(sDestString, nMaxLength))

// Add new formarted string
#define __Sec_Add_sprintf( sDestString, nMaxLength, sFormat, ... )  if ( (1 < __Sec_Remaining_strlen(sDestString, nMaxLength)) )\
                                                                    {   (void)swprintf_s( &sDestString[__Sec_Strnlen(sDestString, nMaxLength)], __Sec_Remaining_strlen(sDestString, nMaxLength), sFormat, __VA_ARGS__ );    }\
                                                                    __Sec_CloseN( sDestString, nMaxLength )

// Add static string with defined length
#define __Sec_strncpy( sDestString, sSrcString, nMaxLength )        (void)wcsncpy_s( sDestString, sSrcString , __Sec_sizeofN(sDestString, nMaxLength) );\
                                                                    __Sec_CloseN( sDestString, nMaxLength )

// Add static string (until maximum allowed length)
#define __Sec_strcpy( sDestString, sSrcString )                     __Sec_strncpy( sDestString, sSrcString, __Sec_sizeof(sDestString) )

// Add static ASC string with defined length
#define __Sec_strncpy_asc( sDestString, sSrcString, nMaxLength )    strncpy_s( sDestString, sSrcString , __Sec_sizeofN(sDestString, nMaxLength) );\
                                                                    __Sec_CloseN( sDestString, nMaxLength )

// Add static ASC string (until maximum allowed length)
#define __Sec_strcpy_asc( sDestString, sSrcString )                 __Sec_strncpy_asc( sDestString, sSrcString, __Sec_sizeof(sDestString) )

// Macros and function for secure add text to a buffer
// ------------------------------------------------------------------------------------------------------


// ------------------------------------------------------------------------------------------------------
// Combine text generating and adding to MultiAnalyser
// Internal text buffer for generating text
wchar_t g_strTextBuffer[4096] = { 0 };

// Pointer for message data (use #undef this and renew #define for changeing)
#define __MSGDATA_POINTER                               pstMessageData

// Combine text generating and adding to MultiAnalyser
#define __Mas_PduOpen_sprintf( sLayer, sFormat, ... )   if ( (__MSGDATA_POINTER) && (__MSGDATA_POINTER)->callback_PduOpen )\
                                                        {   __Sec_Empty( g_strTextBuffer );\
                                                            __Sec_Add_sprintf( g_strTextBuffer, __Sec_sizeof(g_strTextBuffer), sFormat, __VA_ARGS__ );\
                                                            (__MSGDATA_POINTER)->callback_PduOpen( g_strTextBuffer, sLayer, (__MSGDATA_POINTER)->pInternalParameter );\
                                                        } else assert( !"__Mas_PduOpen_sprintf: No callback!" )

#define __Mas_PduText_sprintf( sFormat, ... )           if ( (__MSGDATA_POINTER) && (__MSGDATA_POINTER)->callback_PduAddText )\
                                                        {   __Sec_Empty( g_strTextBuffer );\
                                                            __Sec_Add_sprintf( g_strTextBuffer, __Sec_sizeof(g_strTextBuffer), sFormat, __VA_ARGS__ );\
                                                            (__MSGDATA_POINTER)->callback_PduAddText( g_strTextBuffer, (__MSGDATA_POINTER)->pInternalParameter );\
                                                        } else assert( !"__Mas_PduText_sprintf: No callback!" )

#define __Mas_PduText_strcpy( sString )                 if ( (__MSGDATA_POINTER) && (__MSGDATA_POINTER)->callback_PduAddText )\
                                                        {   (__MSGDATA_POINTER)->callback_PduAddText( sString, (__MSGDATA_POINTER)->pInternalParameter );\
                                                        } else assert( !"__Mas_PduText_strcpy: No callback!" )

#define __Mas_PduText_RawLine()                         __Mas_PduText_RawLine_Function( (__MSGDATA_POINTER)->ucData, (__MSGDATA_POINTER)->ulDataLength, (__MSGDATA_POINTER) );

#define __Mas_PduText_HexBinAsc( pData, nBytes )        __Mas_PduText_HexBinAsc_Function( (const unsigned char * const)pData, (const unsigned int)nBytes, __MSGDATA_POINTER )

#define __Mas_PduCose()                                 if ( (__MSGDATA_POINTER) && (__MSGDATA_POINTER)->callback_PduClose )\
                                                        {    (__MSGDATA_POINTER)->callback_PduClose( (__MSGDATA_POINTER)->pInternalParameter ); }\
                                                        else assert( !"__Mas_PduCose: No callback!" )

// Print hexadecimal data dump
static const wchar_t g_cAscDump[256] =
{ // Print char or replace by dummy
    L'.',L'.',L'.', L'.',L'.',L'.',L'.',L'.', L'.',L'.',L'.',L'.',L'.', L'.',L'.',L'.',
    L'.',L'.',L'.', L'.',L'.',L'.',L'.',L'.', L'.',L'.',L'.',L'.',L'.', L'.',L'.',L'.',
    L' ',L'!',L'\"',L'#',L'$',L'%',L'&',L'\'',L'(',L')',L'*',L'+',L',', L'-',L'.',L'/',
    L'0',L'1',L'2', L'3',L'4',L'5',L'6',L'7', L'8',L'9',L':',L';',L'<', L'=',L'>',L'?',
    L'@',L'A',L'B', L'C',L'D',L'E',L'F',L'G', L'H',L'I',L'J',L'K',L'L', L'M',L'N',L'O',
    L'P',L'Q',L'R', L'S',L'T',L'U',L'V',L'W', L'X',L'Y',L'Z',L'[',L'\\',L']',L'^',L'_',
    L'`',L'a',L'b', L'c',L'd',L'e',L'f',L'g', L'h',L'i',L'j',L'k',L'l', L'm',L'n',L'o',
    L'p',L'q',L'r', L's',L't',L'u',L'v',L'w', L'x',L'y',L'z',L'{',L'|', L'}',L'~',L'.',
    L'.',L'.',L'.', L'.',L'.',L'.',L'.',L'.', L'.',L'.',L'.',L'.',L'.', L'.',L'.',L'.',
    L'.',L'.',L'.', L'.',L'.',L'.',L'.',L'.', L'.',L'.',L'.',L'.',L'.', L'.',L'.',L'.',
    L'',L'',L'', L'',L'',L'',L'',L'', L'',L'',L'',L'',L'', L'.',L'',L'',
    L'',L'',L'', L'',L'',L'',L'',L'', L'',L'',L'',L'',L'', L'',L'',L'',
    L'',L'',L'', L'',L'',L'',L'',L'', L'',L'',L'',L'',L'', L'',L'',L'',
    L'',L'',L'', L'',L'',L'',L'',L'', L'',L'',L'',L'',L'', L'',L'',L'',
    L'',L'',L'', L'',L'',L'',L'',L'', L'',L'',L'',L'',L'', L'',L'',L'',
    L'',L'',L'', L'',L'',L'',L'',L'', L'',L'',L'',L'',L'', L'',L'',L''
};
void __Mas_PduText_HexBinAsc_Function( const unsigned char * const puData, const unsigned int ulBytes, const StructThirdPartyComponent5V_Data * const __MSGDATA_POINTER)
{
    unsigned char   ucByteCount = 0;
    unsigned int    ulIndex     = 0;
    //wchar_t   strLineText[119]    = { 0 }; __Sec_Empty( strLineText );
    wchar_t strHexText[25]      = { 0 }; __Sec_Empty( strHexText  );
    wchar_t strAscText[17]      = { 0 }; __Sec_Empty( strAscText  );
    wchar_t strBinText[73]      = { 0 }; __Sec_Empty( strBinText  ); wchar_t strBinShort[9] = { 0,0,0,0,0,0,0,0, 0 };

    // Add all bytes
    for ( unsigned int ulIndex = 0; (ulBytes) > ulIndex; ulIndex++ )
    { // Make diffrent data types, BIN, HEX and ASC for one BYTE
        for ( unsigned char ucBit = 7; 7 >= ucBit; ucBit-- )
        {   strBinShort[7-ucBit] = (0x01 & (((puData)[ulIndex]) >> ucBit)) ? (L'1') : (L'0');   }
        __Sec_Add_sprintf( strBinText, __Sec_sizeof(strBinText), L"%s "   , strBinShort );
        __Sec_Add_sprintf( strHexText, __Sec_sizeof(strHexText), L"%2.2X ", (puData)[ulIndex] );
        __Sec_Add_sprintf( strAscText, __Sec_sizeof(strAscText), L"%c "   , g_cAscDump[ (puData)[ulIndex] ] );
        ucByteCount++;
        // Need to print line?
        if ( 8 <= ucByteCount )
        { // Join line:
            __Mas_PduText_sprintf( L"%s| %s| %s|\n", strBinText, strHexText, strAscText );
            // Prepare for next line:
            __Sec_Empty( strHexText ); __Sec_Empty( strAscText ); __Sec_Empty( strBinText  ); ucByteCount = 0;
        }
    } // for ( unsigned int ulIndex = 0; (ulBytes) > ulIndex; ulIndex++ )
      // Have unfinisched line?
    if ( ucByteCount )
    { // Fill not used space with white space:
        for ( ; 8 > ucByteCount; ucByteCount++ )
        {   __Sec_Add_sprintf( strBinText, __Sec_sizeof(strBinText), L"         " ); __Sec_Add_sprintf( strHexText, __Sec_sizeof(strHexText), L"   " ); __Sec_Add_sprintf( strAscText, __Sec_sizeof(strAscText), L"  " );   }
        // Join line:
        __Mas_PduText_sprintf( L"%s| %s| %s|\n", strBinText, strHexText, strAscText );
    } // if ( ucByteCount )
}

// Print RAW-Line
static const wchar_t g_cHexNible[16] = { L'0',L'1',L'2',L'3',L'4',L'5',L'6',L'7',L'8',L'9',L'A',L'B',L'C',L'D',L'E',L'F' };
void __Mas_PduText_RawLine_Function( const unsigned char * const puData, const unsigned int ulBits, const StructThirdPartyComponent5V_Data * const __MSGDATA_POINTER)
{
    // Add all bytes
    __Sec_Empty( g_strTextBuffer );
    __Sec_Add_sprintf( g_strTextBuffer, __Sec_sizeof(g_strTextBuffer), L"RAW-Data (%u bits):", ulBits );

    unsigned int    ulWritePos = (unsigned int)__Sec_Strnlen(g_strTextBuffer, __Sec_sizeof(g_strTextBuffer));
    // How many bytes to write (not the last may needed to mask)
    const unsigned int ulBytes = __Sec_Min( ((ulBits+7) >> 3)-1, ((__Sec_sizeof(g_strTextBuffer)-(5+ulWritePos)) / 3) );
    assert( ulBytes == (((ulBits+7) >> 3)-1) ); // Detect low string place
    // Write nibble
    unsigned int ulIndex = 0;
    for ( ; ulBytes > ulIndex; ulIndex++ )
    {
        g_strTextBuffer[ulWritePos++] = L' ';
        g_strTextBuffer[ulWritePos++] = g_cHexNible[(0xF & (puData[ulIndex] >> 4))];
        g_strTextBuffer[ulWritePos++] = g_cHexNible[(0xF & (puData[ulIndex]     ))];
    }
    // Neet mask last byte (remove not present bits)
    const unsigned char ucLastByte = (puData[ulIndex]) & ((7 & ulBits) ? ( 0xFF << (8 - (7 & ulBits)) ) : (0xFF));
    g_strTextBuffer[ulWritePos++] = L' ';
    g_strTextBuffer[ulWritePos++] = g_cHexNible[(0xF & (ucLastByte >> 4))];
    g_strTextBuffer[ulWritePos++] = g_cHexNible[(0xF & (ucLastByte     ))];
    // Terminate
    g_strTextBuffer[ulWritePos++] = L'\n';
    g_strTextBuffer[ulWritePos  ] = 0;

    // Add line
    __Mas_PduText_strcpy( g_strTextBuffer );
}
// ------------------------------------------------------------------------------------------------------



// ------------------------------------------------------------------------------------------------------
// Value for message read position (use #undef this and renew #define for changeing)
#define __MAS_READ_INDEX            ulReadIndex
#define __MAS_READ_SUCCESS          bReadSuccess
#define __Mas_DEFINE_ulReadIndex    unsigned int __MAS_READ_INDEX = 0; bool __MAS_READ_SUCCESS = false
// Define this in example throw exception or jump with goto...
#define __MAS_READ_FAIL_ACTION      assert( !"Read more bits than present" );

// Read wanted amount of bits, call "__MAS_READ_FAIL_ACTION" if fail
#define __Mas_Read8(  nBits )       __Mas_Read_Bits8_Function(  nBits, (__MSGDATA_POINTER)->ucData, (__MSGDATA_POINTER)->ulDataLength, &(__MAS_READ_INDEX), &(__MAS_READ_SUCCESS) ); if ( !(__MAS_READ_SUCCESS) ) { __MAS_READ_FAIL_ACTION; }
#define __Mas_Read16( nBits )       __Mas_Read_Bits16_Function( nBits, (__MSGDATA_POINTER)->ucData, (__MSGDATA_POINTER)->ulDataLength, &(__MAS_READ_INDEX), &(__MAS_READ_SUCCESS) ); if ( !(__MAS_READ_SUCCESS) ) { __MAS_READ_FAIL_ACTION; }
#define __Mas_Read32( nBits )       __Mas_Read_Bits32_Function( nBits, (__MSGDATA_POINTER)->ucData, (__MSGDATA_POINTER)->ulDataLength, &(__MAS_READ_INDEX), &(__MAS_READ_SUCCESS) ); if ( !(__MAS_READ_SUCCESS) ) { __MAS_READ_FAIL_ACTION; }

// Read wanted amount of bits, user defined behaviour of "__MAS_READ_FAIL_ACTION"
#define __Mas_Watch8(  nBits )      __Mas_Read_Bits8_Function(  nBits, (__MSGDATA_POINTER)->ucData, (__MSGDATA_POINTER)->ulDataLength, &(__MAS_READ_INDEX), &(__MAS_READ_SUCCESS) )
#define __Mas_Watch16( nBits )      __Mas_Read_Bits16_Function( nBits, (__MSGDATA_POINTER)->ucData, (__MSGDATA_POINTER)->ulDataLength, &(__MAS_READ_INDEX), &(__MAS_READ_SUCCESS) )
#define __Mas_Watch32( nBits )      __Mas_Read_Bits32_Function( nBits, (__MSGDATA_POINTER)->ucData, (__MSGDATA_POINTER)->ulDataLength, &(__MAS_READ_INDEX), &(__MAS_READ_SUCCESS) )

// Read max 1 to 8 bits of data and return result, increase pulReadBitPos
unsigned char __Mas_Read_Bits8_Function( const unsigned char ucBits, const unsigned char *pucSource, const unsigned int ulMaxBitLength, unsigned int *pulReadBitPos, bool *pbSuccess )
{
    unsigned int        ulValue         = 0;
    unsigned int        ulBytePos       = ((*pulReadBitPos)  >> 3);
    const unsigned int  ulMaxBytePos    = (ulMaxBitLength+7) >> 3 ;
    unsigned char       ucDest          = 0;
    const unsigned char ucReverseBits   =  (8 - ucBits);
    const unsigned char ucBitPos        = ((8 - ((*pulReadBitPos) &  0x7)) + ucReverseBits);

    // Can read?
    if ( 8 < ucBits                                 )   {   assert( 8             >= ucBits                    );  if (pbSuccess) { (*pbSuccess) = false; } return 0;   }
    if ( ulMaxBitLength < ((*pulReadBitPos)+ucBits) )   {   assert( ulMaxBitLength >= ((*pulReadBitPos)+ucBits) ); if (pbSuccess) { (*pbSuccess) = false; } return 0;   }

    // Read data (16 bits, so every possible parts of 8 bits are included for 8 bit value)
                                        ulValue |=  ((unsigned int)pucSource[ulBytePos++] << 8);
    if ( ulMaxBytePos >= ulBytePos )    ulValue |=  ((unsigned int)pucSource[ulBytePos++]     );

    // Shift bits to LSB
    ucDest       = (unsigned char)(ulValue >> ucBitPos);
    // Mask only wanted bits
    ucDest      &= (0xFF >> ucReverseBits);

    // Increase bits
    (*pulReadBitPos)    += ucBits;

    if (pbSuccess) { (*pbSuccess) = true; }
    return ucDest;
}

// Read max 1 to 16 bits of data and return result, increase pulReadBitPos
unsigned short __Mas_Read_Bits16_Function( const unsigned char ucBits, const unsigned char *pucSource, const unsigned int ulMaxBitLength, unsigned int *pulReadBitPos, bool *pbSuccess)
{
    unsigned int        ulValue         = 0;
    unsigned int        ulBytePos       = ((*pulReadBitPos)  >> 3);
    const unsigned int  ulMaxBytePos    = (ulMaxBitLength+7) >> 3 ;
    unsigned short      usDest          = 0;
    const unsigned char ucReverseBits   = (16 - ucBits);
    const unsigned char ucBitPos        = ((8 - ((*pulReadBitPos) &  0x7)) + ucReverseBits);

    // Can read?
    if ( 16 < ucBits                                )   {   assert( 16             >= ucBits                    ); if (pbSuccess) { (*pbSuccess) = false; } return 0;   }
    if ( ulMaxBitLength < ((*pulReadBitPos)+ucBits) )   {   assert( ulMaxBitLength >= ((*pulReadBitPos)+ucBits) ); if (pbSuccess) { (*pbSuccess) = false; } return 0;   }

    // Read data (24 bits, so every possible parts of 8 bits are included for 16 bit value)
                                        ulValue |=  ((unsigned int)pucSource[ulBytePos++] << 16);
    if ( ulMaxBytePos >= ulBytePos )    ulValue |=  ((unsigned int)pucSource[ulBytePos++] <<  8);
    if ( ulMaxBytePos >= ulBytePos )    ulValue |=  ((unsigned int)pucSource[ulBytePos++]      );

    // Shift bits to LSB
    usDest       = (unsigned short)(ulValue >> ucBitPos);
    // Mask only wanted bits
    usDest      &= (0xFFFF >> ucReverseBits);

    // Increase bits
    (*pulReadBitPos)    += ucBits;

    if (pbSuccess) { (*pbSuccess) = true; }
    return usDest;
}

// Read max 1 to 32 bits of data and return result, increase pulReadBitPos
unsigned int __Mas_Read_Bits32_Function( const unsigned char ucBits, const unsigned char *pucSource, const unsigned int ulMaxBitLength, unsigned int *pulReadBitPos, bool *pbSuccess)
{
    unsigned long long  ullValue        = 0;
    unsigned int        ulDest          = 0;
    unsigned int        ulBytePos       = ((*pulReadBitPos)  >> 3);
    const unsigned int  ulMaxBytePos    = (ulMaxBitLength+7) >> 3 ;
    const unsigned char ucReverseBits   = (32 - ucBits);
    const unsigned char ucBitPos        = ((8 - ((*pulReadBitPos) &  0x7)) + ucReverseBits);

    // Can read?
    if ( 32 < ucBits                                )   {   assert( 32             >= ucBits                    ); if (pbSuccess) { (*pbSuccess) = false; } return 0;   }
    if ( ulMaxBitLength < ((*pulReadBitPos)+ucBits) )   {   assert( ulMaxBitLength >= ((*pulReadBitPos)+ucBits) ); if (pbSuccess) { (*pbSuccess) = false; } return 0;   }

    // Read data (40 bits, so every possible parts of 8 bits are included for 32 bit value)
                                        ullValue    |=  ((unsigned long long)pucSource[ulBytePos++] << 32);
    if ( ulMaxBytePos >= ulBytePos )    ullValue    |=  ((unsigned long long)pucSource[ulBytePos++] << 24);
    if ( ulMaxBytePos >= ulBytePos )    ullValue    |=  ((unsigned long long)pucSource[ulBytePos++] << 16);
    if ( ulMaxBytePos >= ulBytePos )    ullValue    |=  ((unsigned long long)pucSource[ulBytePos++] <<  8);
    if ( ulMaxBytePos >= ulBytePos )    ullValue    |=  ((unsigned long long)pucSource[ulBytePos++]      );

    // Shift bits to LSB
    ulDest       = (unsigned int)(ullValue >> ucBitPos);
    // Mask only wanted bits
    ulDest      &= (0xFFFFFFFF >> ucReverseBits);

    // Increase bits
    (*pulReadBitPos)    += ucBits;

    if (pbSuccess) { (*pbSuccess) = true; }
    return ulDest;
}
// ------------------------------------------------------------------------------------------------------


// ------------------------------------------------------------------------------------------------------
typedef enum EnumResultFilterSettings : unsigned long long
{ // Values for "StructThirdPartyComponent5V_Result::ullFilterMask"
    Filter_ViewAll                                  = 0,
    // ------------------------------------------------------------------------------------------------------------------------------------------------
    TetraTmo_Supress_Slot_1                         = 0x0000000000000001,   // Supress timeslot
    TetraTmo_Supress_Slot_2                         = 0x0000000000000002,   // Supress timeslot
    TetraTmo_Supress_Slot_3                         = 0x0000000000000004,   // Supress timeslot
    TetraTmo_Supress_Slot_4                         = 0x0000000000000008,   // Supress timeslot

    TetraTmo_Supress_DL_NullPdu                     = 0x0000000000000010,   // Suppress NULL-PDU as end of data in PDU
    TetraTmo_Supress_DL_EqualBroadCast              = 0x0000000000000020,   // SYNC, SYSINFO(-Q/DA), ACCESS-DEFINE
    TetraTmo_Supress_DL_EqualDnwrk                  = 0x0000000000000040,   // D-NWRK(-DA), D-NWRK Extension
    TetraTmo_Supress_DL_NotDecoded                  = 0x0000000000000080,   // Supress physical layer information
    TetraTmo_Supress_DL_USignal                     = 0x0000000000000100,   // Supress MAC-U-SIGNAL on FACCH
    TetraTmo_Supress_DL_ErrorInPdu                  = 0x0000000000001000,   // Supress PDUs if an error occured

    TetraTmo_Supress_UL_NullPdu                     = 0x0000000000000200,   // Suppress NULL-PDU as end of data in PDU (not stand alone NULL-PDU!)
    TetraTmo_Supress_UL_NotDecodedBelowThreshhold   = 0x0000000000000400,   // Supress physical layer information, if they are below RSSI treshhold
    TetraTmo_Supress_UL_USignal                     = 0x0000000000000800,   // Supress MAC-U-SIGNAL on FACCH
    TetraTmo_Supress_UL_ErrorInPdu                  = 0x0000000000002000,   // Supress PDUs if an error occured

    TetraTmo_Supress_UserDefined_1                  = 0x0000000000010000,   // Usage from external DLL analysis
    TetraTmo_Supress_UserDefined_2                  = 0x0000000000020000,   // Usage from external DLL analysis
    // ------------------------------------------------------------------------------------------------------------------------------------------------
    TetraDmo_Supress_Slot_1                         = 0x0000000000000001,   // Supress timeslot
    TetraDmo_Supress_Slot_2                         = 0x0000000000000002,   // Supress timeslot
    TetraDmo_Supress_Slot_3                         = 0x0000000000000004,   // Supress timeslot
    TetraDmo_Supress_Slot_4                         = 0x0000000000000008,   // Supress timeslot

    TetraDmo_Supress_NoCall_Slots                   = 0x0000000000000010,   // Supress timeslot
    TetraDmo_Supress_Master_Slots                   = 0x0000000000000020,   // Supress timeslot
    TetraDmo_Supress_Slave_Slots                    = 0x0000000000000040,   // Supress timeslot

    TetraDmo_Supress_NotDecodedBelowThreshhold      = 0x0000000000001000,   // Supress physical layer information
    TetraDmo_Supress_Repeated                       = 0x0000000000002000,   // Supress repeated messages(frame count down)
    TetraDmo_Supress_LateEntry                      = 0x0000000000004000,   // Supress DM-OCCPIED and DM-RESERVERD
    TetraDmo_Supress_USignal                        = 0x0000000000008000,   // Supress MAC-U-SIGNAL
    TetraDmo_Supress_Idle_DPresSync                 = 0x0000000000010000,   // Supress DPres sync with IDLE channel state
    TetraDmo_Supress_ErrorInPdu                     = 0x0000000000020000,   // Supress PDUs if an error occured
    // ------------------------------------------------------------------------------------------------------------------------------------------------
    Dmr_Supress_Slot_1                              = 0x0000000000000001,   // Supress timeslot
    Dmr_Supress_Slot_2                              = 0x0000000000000002,   // Supress timeslot

    Dmr_Supress_DL_IDLE_Pdu                         = 0x0000000000000010,   // Suppress IDLE-PDU
    Dmr_Supress_DL_EqualBroadCast                   = 0x0000000000000020,   // Suppress redunant broadcast
    Dmr_Supress_DL_NotDecoded                       = 0x0000000000000040,   // Supress physical layer information
    Dmr_Supress_DL_L2_CH_INFO                       = 0x0000000000000080,   // Supress SlotType/EMB/TACT if no higher layer present
    Dmr_Supress_DL_LateEntry                        = 0x0000000000000100,   // Supress late entry information in embedded channel
    Dmr_Supress_DL_ErrorInPdu                       = 0x0000000000100000,   // Supress PDUs if an error occured

    Dmr_Supress_UL_IDLE_Pdu                         = 0x0000000000001000,   // Suppress IDLE-PDU
    Dmr_Supress_UL_EqualBroadCast                   = 0x0000000000002000,   // Suppress redunant broadcast
    Dmr_Supress_UL_NotDecoded                       = 0x0000000000004000,   // Supress physical layer information, if they are below RSSI treshhold
    Dmr_Supress_UL_L2_CH_INFO                       = 0x0000000000008000,   // Supress SlotType/EMB/TACT if no higher layer present
    Dmr_Supress_UL_LateEntry                        = 0x0000000000010000,   // Supress late entry information in embedded channel
    Dmr_Supress_UL_ErrorInPdu                       = 0x0000000000200000    // Supress PDUs if an error occured
    // ------------------------------------------------------------------------------------------------------------------------------------------------
} EnumResultFilterSettings;
// ------------------------------------------------------------------------------------------------------


// DLL provides wanted types of data for it own analysing...
// Returns 0: If successfull, all other values marking an error
THIRD_PARTY_COMPONENT_5V int ThirdPartyComponent5V_Init( StructThirdPartyComponent5V_Init *pstRegisterMessages )
{
    // Have result struct?
    if ( NULL == pstRegisterMessages )
    {   return -1;  }

    // Valid result struct?
    assert( STRUCT_THIRDPARTYCOMPONENT5V_INIT__VERSION == 2 );
    switch ( pstRegisterMessages->ulVersion )
    {
        case 1: // First version of struct
        case 2: // Extended version of version 1 struct
        break;

        default:
        return -2;
    } //  switch ( pstRegisterMessages->ulVersion )

    // Internal init
    __Sec_Empty( g_strTextBuffer );

    // Version/Company/Copyright string
    __Sec_strcpy_asc( pstRegisterMessages->strVersion   , "ThirdPartyComponent5V, Version 0.0" );

    // Supported Protokoll, which type of protokoll data is supported
    pstRegisterMessages->ulProtokollSupport     = ThirdPartyComponent5V_TetraTmo;
    pstRegisterMessages->pDllInstance           = NULL;

    // All registred data
    pstRegisterMessages->ulRegisterCount        = 0;
    memset( pstRegisterMessages->stRegisterData , 0 , sizeof(pstRegisterMessages->stRegisterData) );

    StructThirdPartyComponent5V_RegData *pstRegData = NULL;
    //// --------------------------------------------------------------------
    // Set data: Analyse registred PDU* NOTE1                   ulType: UMac-PDU Type* NOTE2        , ulExtendedType: -  or "MAC-FRAG, MAC-END, D/U-BLCK" (0xFFFFFFFF=ALL)
    pstRegData = &pstRegisterMessages->stRegisterData[ pstRegisterMessages->ulRegisterCount ];
    pstRegData->eRegisterType     = ThirdPartyComponent5V_UMac_Pdu;
    pstRegData->ulDirection       = 0x03;     // DL+UL
    pstRegData->ulType            = UINT_MAX; // ALL
    pstRegData->ulExtendedType[0] = UINT_MAX; // ALL
    pstRegData->ulExtendedType[1] = UINT_MAX; // ALL
    pstRegisterMessages->ulRegisterCount++;
    // --------------------
    // Set data
    pstRegData = &pstRegisterMessages->stRegisterData[ pstRegisterMessages->ulRegisterCount ];
    pstRegData->eRegisterType     = ThirdPartyComponent5V_UMac_TCH;
    pstRegData->ulDirection       = 0x03;     // DL+UL
    pstRegData->ulType            = UINT_MAX; // ALL
    pstRegData->ulExtendedType[0] = UINT_MAX; // ALL
    pstRegData->ulExtendedType[1] = UINT_MAX; // ALL
    pstRegisterMessages->ulRegisterCount++;
    // --------------------
    // Set data
    pstRegData = &pstRegisterMessages->stRegisterData[ pstRegisterMessages->ulRegisterCount ];
    pstRegData->eRegisterType     = ThirdPartyComponent5V_UMac_UPlane;
    pstRegData->ulDirection       = 0x03;     // DL+UL
    pstRegData->ulType            = UINT_MAX; // ALL
    pstRegData->ulExtendedType[0] = UINT_MAX; // ALL
    pstRegData->ulExtendedType[1] = UINT_MAX; // ALL
    pstRegisterMessages->ulRegisterCount++;
    // --------------------
    // Set data: Analyse registred PDU* NOTE1                   ulType: LLC-PDU Type                , ulExtendedType: - or "AL-X-*, L2-SIGNAL*" (0xFFFFFFFF=ALL)
    pstRegData = &pstRegisterMessages->stRegisterData[ pstRegisterMessages->ulRegisterCount ];
    pstRegData->eRegisterType     = ThirdPartyComponent5V_Llc_Pdu;
    pstRegData->ulDirection       = 0x03;     // DL+UL
    pstRegData->ulType            = UINT_MAX; // ALL
    pstRegData->ulExtendedType[0] = UINT_MAX; // ALL
    pstRegData->ulExtendedType[1] = UINT_MAX; // ALL
    pstRegisterMessages->ulRegisterCount++;
    // --------------------
    // Set data: Analyse registred PDU* NOTE1                   ulType: MLE-PDU Type * NOTE3        , ulExtendedType: -
    pstRegData = &pstRegisterMessages->stRegisterData[ pstRegisterMessages->ulRegisterCount ];
    pstRegData->eRegisterType     = ThirdPartyComponent5V_Mle_Pdu;
    pstRegData->ulDirection       = 0x03;     // DL
    pstRegData->ulType            = UINT_MAX; // ALL
    pstRegData->ulExtendedType[0] = UINT_MAX; // ALL
    pstRegData->ulExtendedType[1] = UINT_MAX; // ALL
    pstRegisterMessages->ulRegisterCount++;
    // --------------------
    // Set data: Analyse registred PDU* NOTE1                   ulType: MLE-PDU Type * NOTE3        , ulExtendedType: -
    pstRegData = &pstRegisterMessages->stRegisterData[ pstRegisterMessages->ulRegisterCount ];
    pstRegData->eRegisterType     = ThirdPartyComponent5V_Mle_ProtocolDiscriminator;
    pstRegData->ulDirection       = 0x03;     // DL
    pstRegData->ulType            = UINT_MAX; // ALL
    pstRegData->ulExtendedType[0] = UINT_MAX; // ALL
    pstRegData->ulExtendedType[1] = UINT_MAX; // ALL
    pstRegisterMessages->ulRegisterCount++;
    // --------------------
    // Set data: Analyse registred PDU* NOTE1                   ulType: MM-PDU Type                 , ulExtendedType: - or "U/D-AUTHENTICATION, U/D-OTAR,..." (0xFFFFFFFF=ALL)
    pstRegData = &pstRegisterMessages->stRegisterData[ pstRegisterMessages->ulRegisterCount ];
    pstRegData->eRegisterType     = ThirdPartyComponent5V_Mm_Pdu;
    pstRegData->ulDirection       = 0x03;     // DL+UL
    pstRegData->ulType            = UINT_MAX; // ALL
    pstRegData->ulExtendedType[0] = UINT_MAX; // ALL
    pstRegData->ulExtendedType[1] = UINT_MAX; // ALL
    pstRegisterMessages->ulRegisterCount++;
    // --------------------
    // Set data: Analyse registred PDU* NOTE1                   ulType: CMCE-PDU Type               , ulExtendedType: -
    pstRegData = &pstRegisterMessages->stRegisterData[ pstRegisterMessages->ulRegisterCount ];
    pstRegData->eRegisterType     = ThirdPartyComponent5V_Cmce_Pdu;
    pstRegData->ulDirection       = 0x03;     // DL+UL
    pstRegData->ulType            = UINT_MAX; // ALL
    pstRegData->ulExtendedType[0] = UINT_MAX; // ALL
    pstRegData->ulExtendedType[1] = UINT_MAX; // ALL
    pstRegisterMessages->ulRegisterCount++;
    // --------------------
    // Set data: Analyse content of data (TL/No TL)             ulType: -                           , ulExtendedType: -
    pstRegData = &pstRegisterMessages->stRegisterData[ pstRegisterMessages->ulRegisterCount ];
    pstRegData->eRegisterType     = ThirdPartyComponent5V_SdsType4_Content_All;
    pstRegData->ulDirection       = 0x03; // DL+UL
    pstRegData->ulType            = UINT_MAX; // ALL
    pstRegData->ulExtendedType[0] = UINT_MAX; // ALL
    pstRegData->ulExtendedType[1] = UINT_MAX; // ALL
    pstRegisterMessages->ulRegisterCount++;
    // --------------------
    // Set data: Analyse registred PDU* NOTE1                   ulType: SNDCP-PDU Type              , ulExtendedType: -
    pstRegData = &pstRegisterMessages->stRegisterData[ pstRegisterMessages->ulRegisterCount ];
    pstRegData->eRegisterType     = ThirdPartyComponent5V_Sndcp_Pdu;
    pstRegData->ulDirection       = 0x03;     // DL+UL
    pstRegData->ulType            = UINT_MAX; // ALL
    pstRegData->ulExtendedType[0] = UINT_MAX; // ALL
    pstRegData->ulExtendedType[1] = UINT_MAX; // ALL
    pstRegisterMessages->ulRegisterCount++;
    // --------------------
    // Set data: Analyse registred PDU,* NOTE1                  ulType: D/U-FACILITY: SS type       , ulExtendedType[0]: SS-PDU type(0xFFFFFFFF=ALL)
    pstRegData = &pstRegisterMessages->stRegisterData[ pstRegisterMessages->ulRegisterCount ];
    pstRegData->eRegisterType     = ThirdPartyComponent5V_Ss_Pdu;
    pstRegData->ulDirection       = 0x03;     // DL+UL
    pstRegData->ulType            = UINT_MAX; // ALL
    pstRegData->ulExtendedType[0] = UINT_MAX; // ALL
    pstRegData->ulExtendedType[1] = UINT_MAX; // ALL
    pstRegisterMessages->ulRegisterCount++;
    // --------------------

    return 0;
}

// Multianalyser provides data for analysing:
// Input : StructThirdPartyComponent5V_Data  : The data themself for external analysing
// Output: StructThirdPartyComponent5V_Result: What is todo for multianalyser.
// Returns 0: Result is stored in StructThirdPartyComponent5V_Result, all other values are errors
THIRD_PARTY_COMPONENT_5V int ThirdPartyComponent5V_Data( void *pDllInstance, const StructThirdPartyComponent5V_Data *pstMessageData, StructThirdPartyComponent5V_Result *pstAnalyseResult )
{
    // Have result struct?
    if ( NULL == (__MSGDATA_POINTER))
    {   return -1;  }

    // Have result struct?
    if ( NULL == pstAnalyseResult)
    {   return -2;  }

    // Valid result struct?
    if ( STRUCT_THIRDPARTYCOMPONENT5V_DATA__VERSION != (__MSGDATA_POINTER)->ulVersion )
    {   return -3;  }

    // Valid data?
    if ( STRUCT_THIRDPARTYCOMPONENT5V_RESULT__VERSION != pstAnalyseResult->ulVersion )
    {   return -4;  }

    // Ensure nothing returned
    pstAnalyseResult->eResult           = ThirdPartyComponent5V_Result_Nothing;
    pstAnalyseResult->ullFilterMask     = EnumResultFilterSettings::Filter_ViewAll;
    pstAnalyseResult->ulAnalyseLength   = 0;

    __Mas_DEFINE_ulReadIndex;   // unsigned int ulReadIndex = 0

    // Depending from message type write text for MSC
    switch ((__MSGDATA_POINTER)->eRegisterType )
    {
        case ThirdPartyComponent5V_UMac_Pdu:            // Analyse registred PDU* NOTE1                 ulType: UMac-PDU Type* NOTE2        , ulExtendedType: -  or "MAC-FRAG, MAC-END, D/U-BLCK" (0xFFFFFFFF=ALL)
        case ThirdPartyComponent5V_UMac_Unknown:        // Analyse not known PDU by analysis            ulType: -                           , ulExtendedType: -
        {   // ---------------------------------------------------------------------------------------------------------------------
            __Mas_PduOpen_sprintf( g_pstrLayerUMac, L"MY-UMAC-PDU" );
            __Mas_PduText_RawLine();

            // Print hexadecimal data
            const unsigned int ulByteLength = __Sec_Min( (sizeof((__MSGDATA_POINTER)->ucData) << 3), (((__MSGDATA_POINTER)->ulDataLength+7) >> 3) ); // Convert into bytes
            if ( ulByteLength )
            {   // Dump data
                __Mas_PduText_sprintf( L"Dump data: %u bits (%u bytes)\n",  ((__MSGDATA_POINTER)->ulDataLength), ulByteLength );
                __Mas_PduText_HexBinAsc((__MSGDATA_POINTER)->ucData, ulByteLength );
            }
            __Mas_PduCose();
        }   // ---------------------------------------------------------------------------------------------------------------------
        break;

        case ThirdPartyComponent5V_UMac_TCH:            // Analyse speech on TCH channel                ulType: -                           , ulExtendedType: - (No airinterface decryption and circuit mode for now)
        {   // ---------------------------------------------------------------------------------------------------------------------
            switch ((__MSGDATA_POINTER)->ulDataLength )
            {
                case 137:   __Mas_PduOpen_sprintf( g_pstrLayerUMac, L"MY-TCH/S (half)" );   break;
                case 274:   __Mas_PduOpen_sprintf( g_pstrLayerUMac, L"MY-TCH/S (full)" );   break;
                case 432:   __Mas_PduOpen_sprintf( g_pstrLayerUMac, L"MY-TCH/7.2" );        break;
                case 288:   __Mas_PduOpen_sprintf( g_pstrLayerUMac, L"MY-TCH/4.8" );        break;
                case 144:   __Mas_PduOpen_sprintf( g_pstrLayerUMac, L"MY-TCH/2.4" );        break;
                default:    __Mas_PduOpen_sprintf( g_pstrLayerUMac, L"MY-TCH" );            break;
            } // switch ( (__MSGDATA_POINTER)->ulDataLength )
            __Mas_PduText_RawLine();

            // Set Filter
            pstAnalyseResult->eResult = ThirdPartyComponent5V_Result_NothingButFilter;
            if (      0x01 == (__MSGDATA_POINTER)->ulDirection ) {   pstAnalyseResult->ullFilterMask = EnumResultFilterSettings::TetraTmo_Supress_DL_USignal;    }
            else if ( 0x02 == (__MSGDATA_POINTER)->ulDirection ) {   pstAnalyseResult->ullFilterMask = EnumResultFilterSettings::TetraTmo_Supress_UL_USignal;    }

            // Print hexadecimal data
            const unsigned int ulByteLength = __Sec_Min( (sizeof((__MSGDATA_POINTER)->ucData) << 3), (((__MSGDATA_POINTER)->ulDataLength+7) >> 3) ); // Convert into bytes
            if ( ulByteLength )
            {   // Dump data
                __Mas_PduText_sprintf( L"Dump data: %u bits (%u bytes)\n",  ((__MSGDATA_POINTER)->ulDataLength), ulByteLength );
                __Mas_PduText_HexBinAsc((__MSGDATA_POINTER)->ucData, ulByteLength );
            }
            __Mas_PduCose();
        }   // ---------------------------------------------------------------------------------------------------------------------
        break;

        case ThirdPartyComponent5V_UMac_UPlane:         // Analyse UPlane-Stealing on TCH channel       ulType: -                           , ulExtendedType: - (No airinterface decryption and circuit mode for now)
        {   // ---------------------------------------------------------------------------------------------------------------------
            __Mas_PduOpen_sprintf( g_pstrLayerUMac, L"MY-UPLane" );
            __Mas_PduText_RawLine();

            // Set Filter
            pstAnalyseResult->eResult = ThirdPartyComponent5V_Result_NothingButFilter;
            if (      0x01 == (__MSGDATA_POINTER)->ulDirection ) {   pstAnalyseResult->ullFilterMask = EnumResultFilterSettings::TetraTmo_Supress_DL_USignal;    }
            else if ( 0x02 == (__MSGDATA_POINTER)->ulDirection ) {   pstAnalyseResult->ullFilterMask = EnumResultFilterSettings::TetraTmo_Supress_UL_USignal;    }

            // Print hexadecimal data
            const unsigned int ulByteLength = __Sec_Min( (sizeof((__MSGDATA_POINTER)->ucData) << 3), (((__MSGDATA_POINTER)->ulDataLength+7) >> 3) ); // Convert into bytes
            if ( ulByteLength )
            {   // Dump data
                __Mas_PduText_sprintf( L"Dump data: %u bits (%u bytes)\n",  ((__MSGDATA_POINTER)->ulDataLength), ulByteLength );
                __Mas_PduText_HexBinAsc((__MSGDATA_POINTER)->ucData, ulByteLength );
            }
            __Mas_PduCose();
        }   // ---------------------------------------------------------------------------------------------------------------------
        break;

        case ThirdPartyComponent5V_Llc_Pdu:             // Analyse registred PDU* NOTE1                 ulType: LLC-PDU Type                , ulExtendedType: - or "AL-X-*, L2-SIGNAL-*" (0xFFFFFFFF=ALL)
        case ThirdPartyComponent5V_Llc_Pdu_Unknown:     // Analyse not known PDU by analysis            ulType: -                           , ulExtendedType: -
        {   // ---------------------------------------------------------------------------------------------------------------------
            __Mas_PduOpen_sprintf( g_pstrLayerLlc, L"MY-LLC-PDU" );
            __Mas_PduText_RawLine();

            // Print hexadecimal data
            const unsigned int ulByteLength = __Sec_Min( (sizeof((__MSGDATA_POINTER)->ucData) << 3), (((__MSGDATA_POINTER)->ulDataLength+7) >> 3) ); // Convert into bytes
            if ( ulByteLength )
            {   // Dump data
                __Mas_PduText_sprintf( L"Dump data: %u bits (%u bytes)\n",  ((__MSGDATA_POINTER)->ulDataLength), ulByteLength );
                __Mas_PduText_HexBinAsc((__MSGDATA_POINTER)->ucData, ulByteLength );
            }
            __Mas_PduCose();
        }   // ---------------------------------------------------------------------------------------------------------------------
        break;

        case ThirdPartyComponent5V_Mle_ProtocolDiscriminator: // Analyse registred layer                ulType: MLE Protocol discriminator  , ulExtendedType: -
        {   // ---------------------------------------------------------------------------------------------------------------------
            switch ( pstMessageData->ulType )
            {
                case 1: __Mas_PduOpen_sprintf( g_pstrLayerMle, L"MY-MLE-PRO-DIS (MM protocol)" );       break;
                case 2: __Mas_PduOpen_sprintf( g_pstrLayerMle, L"MY-MLE-PRO-DIS (CMCE protocol)" );     break;
                case 4: __Mas_PduOpen_sprintf( g_pstrLayerMle, L"MY-MLE-PRO-DIS (SNDCP protocol)" );    break;
                case 5: return -1; // ThirdPartyComponent5V_Mle_Pdu: __Mas_PduOpen_sprintf( g_pstrLayerMle, L"MY-MLE-PRO-DIS (MLE protocol)" );     break;
                case 6: __Mas_PduOpen_sprintf( g_pstrLayerMle, L"MY-MLE-PRO-DIS (TETRA management)" );  break;
                case 7: __Mas_PduOpen_sprintf( g_pstrLayerMle, L"MY-MLE-PRO-DIS (testing)" );           break;
                default:__Mas_PduOpen_sprintf( g_pstrLayerMle, L"MY-MLE-PRO-DIS" );                     break;
            }
            __Mas_PduText_RawLine();

            // Print hexadecimal data
            const unsigned int ulByteLength = __Sec_Min( (sizeof((__MSGDATA_POINTER)->ucData) << 3), (((__MSGDATA_POINTER)->ulDataLength+7) >> 3) ); // Convert into bytes
            if ( ulByteLength )
            {
                __Mas_PduText_sprintf( L"Dump data: %u bits (%u bytes)\n",  ((__MSGDATA_POINTER)->ulDataLength), ulByteLength );
                // Dump data
                __Mas_PduText_HexBinAsc((__MSGDATA_POINTER)->ucData, ulByteLength );
            }
            __Mas_PduCose();
        }   // ---------------------------------------------------------------------------------------------------------------------
        break;

        case ThirdPartyComponent5V_Mle_Pdu:             // Analyse registred PDU* NOTE1                 ulType: MLE-PDU Type * NOTE3        , ulExtendedType: -
        case ThirdPartyComponent5V_Mle_Pdu_Unknown:     // Analyse not known PDU by analysis            ulType: -                           , ulExtendedType: -
        {   // ---------------------------------------------------------------------------------------------------------------------
            switch ( pstMessageData->ulType )
            {
                case 0x00000200:    __Mas_PduOpen_sprintf(   g_pstrLayerMle_Llc, L"MY-MLE-SYNC" );      break;
                case 0x00000201:    __Mas_PduOpen_sprintf(   g_pstrLayerMle_Llc, L"MY-MLE-SYSINFO" );   break;
                case 2:             if ( 0x01 == pstMessageData->ulDirection )
                                    { __Mas_PduOpen_sprintf( g_pstrLayerMle    , L"MY-D-NWRK" );        break; }
                default:            __Mas_PduOpen_sprintf(   g_pstrLayerMle    , L"MY-MLE-PDU" );       break;
            }
            __Mas_PduText_RawLine();

            // Print hexadecimal data
            const unsigned int ulByteLength = __Sec_Min( (sizeof((__MSGDATA_POINTER)->ucData) << 3), (((__MSGDATA_POINTER)->ulDataLength+7) >> 3) ); // Convert into bytes
            if ( ulByteLength )
            {   // Dump data
                __Mas_PduText_sprintf( L"Dump data: %u bits (%u bytes)\n",  ((__MSGDATA_POINTER)->ulDataLength), ulByteLength );
                __Mas_PduText_HexBinAsc((__MSGDATA_POINTER)->ucData, ulByteLength );
            }
            __Mas_PduCose();
        }   // ---------------------------------------------------------------------------------------------------------------------
        break;

        case ThirdPartyComponent5V_Mm_Pdu:              // Analyse registred PDU* NOTE1                 ulType: MM-PDU Type                 , ulExtendedType: - or "U/D-AUTHENTICATION, U/D-OTAR,..." (0xFFFFFFFF=ALL)
        case ThirdPartyComponent5V_Mm_Pdu_Unknown:      // Analyse not known PDU by analysis            ulType: -                           , ulExtendedType: -
        {   // ---------------------------------------------------------------------------------------------------------------------
            __Mas_PduOpen_sprintf( g_pstrLayerMmCmce, L"MY-MM-PDU" );
            __Mas_PduText_RawLine();

            // Print hexadecimal data
            const unsigned int ulByteLength = __Sec_Min( (sizeof((__MSGDATA_POINTER)->ucData) << 3), (((__MSGDATA_POINTER)->ulDataLength+7) >> 3) ); // Convert into bytes
            if ( ulByteLength )
            {   // Dump data
                __Mas_PduText_sprintf( L"Dump data: %u bits (%u bytes)\n",  ((__MSGDATA_POINTER)->ulDataLength), ulByteLength );
                __Mas_PduText_HexBinAsc((__MSGDATA_POINTER)->ucData, ulByteLength );
            }
            __Mas_PduCose();
        }   // ---------------------------------------------------------------------------------------------------------------------
        break;

        case ThirdPartyComponent5V_Cmce_Pdu:            // Analyse registred PDU* NOTE1                 ulType: CMCE-PDU Type               , ulExtendedType: -
        case ThirdPartyComponent5V_Cmce_Pdu_Unknown:    // Analyse not known PDU by analysis            ulType: -                           , ulExtendedType: -
        {   // ---------------------------------------------------------------------------------------------------------------------
            __Mas_PduOpen_sprintf( g_pstrLayerMmCmce, L"MY-CMCE-PDU" );
            __Mas_PduText_RawLine();

            // Print hexadecimal data
            const unsigned int ulByteLength = __Sec_Min( (sizeof((__MSGDATA_POINTER)->ucData) << 3), (((__MSGDATA_POINTER)->ulDataLength+7) >> 3) ); // Convert into bytes
            if ( ulByteLength )
            {   // Dump data
                __Mas_PduText_sprintf( L"Dump data: %u bits (%u bytes)\n",  ((__MSGDATA_POINTER)->ulDataLength), ulByteLength );
                __Mas_PduText_HexBinAsc((__MSGDATA_POINTER)->ucData, ulByteLength );
            }
            __Mas_PduCose();
        }   // ---------------------------------------------------------------------------------------------------------------------
        break;

        case ThirdPartyComponent5V_SdsStatus_Content:   // Analyse content of data from SNDCP-DATA PDU  ulType: - * NOTE5                   , ulExtendedType: -
        {   // ---------------------------------------------------------------------------------------------------------------------
            __Mas_PduOpen_sprintf( g_pstrLayerTlSdsSndcpSs, L"MY-STATUS SDS" );
            __Mas_PduText_RawLine();

            // Print hexadecimal data
            const unsigned int ulByteLength = __Sec_Min( (sizeof((__MSGDATA_POINTER)->ucData) << 3), (((__MSGDATA_POINTER)->ulDataLength+7) >> 3) );
            if ( ulByteLength )
            {   // Dump data
                __Mas_PduText_sprintf( L"Status: %u bits (%u bytes)\n",  ((__MSGDATA_POINTER)->ulDataLength), ulByteLength );
                __Mas_PduText_HexBinAsc((__MSGDATA_POINTER)->ucData, ulByteLength );
            }
            __Mas_PduCose();
        }   // ---------------------------------------------------------------------------------------------------------------------
        break;

        case ThirdPartyComponent5V_SdsType1_Content:    // Analyse content of data                      ulType: -                           , ulExtendedType: -
        case ThirdPartyComponent5V_SdsType2_Content:    // Analyse content of data:                     ulType: -                           , ulExtendedType: -
        case ThirdPartyComponent5V_SdsType3_Content:    // Analyse content of data                      ulType: -                           , ulExtendedType: -
        case ThirdPartyComponent5V_SdsType4_Content_All:// Analyse content of data                      ulType: -                           , ulExtendedType: -
        case ThirdPartyComponent5V_SdsType4_Content_TL: // Analyse content of data (TL/No TL)           ulType: -                           , ulExtendedType: -
        case ThirdPartyComponent5V_SdsType4_Content_NoTL://Analyse content of data (only no TL)         ulType: -                           , ulExtendedType: -
        case ThirdPartyComponent5V_SdsType4_PID:        // Analyse content of data (only TL)            ulType: - * NOTE4                   , ulExtendedType: -
        {   // ---------------------------------------------------------------------------------------------------------------------
            unsigned char ucPID = 0;
            if (ThirdPartyComponent5V_SdsType4_Content_TL == (__MSGDATA_POINTER)->eRegisterType)
            {
                // PID is not set by init function, but deliverd because PID is before TL-Header and not included in content data
                assert(0x80 & (__MSGDATA_POINTER)->ulType);
                ucPID = (__MSGDATA_POINTER)->ulType;
            }
            else
            { // Read PID
                ucPID = __Mas_Read8(8);
            }

            // Define filter
            if ( 130 == ucPID ) // <- Text Messaging
            { // Hide only self analysis, but keep MAS analysis, stop here before printing
                if (      0x01 == (__MSGDATA_POINTER)->ulDirection && (TetraTmo_Supress_UserDefined_1 & (__MSGDATA_POINTER)->ullFilterMask) ) {   break;  }
                else if ( 0x02 == (__MSGDATA_POINTER)->ulDirection && (TetraTmo_Supress_UserDefined_2 & (__MSGDATA_POINTER)->ullFilterMask) ) {   break;  }
            }
            else
            { // Will hide full message, including previous layer
                if (      0x01 == (__MSGDATA_POINTER)->ulDirection ) {   pstAnalyseResult->ullFilterMask = EnumResultFilterSettings::TetraTmo_Supress_UserDefined_1; }
                else if ( 0x02 == (__MSGDATA_POINTER)->ulDirection ) {   pstAnalyseResult->ullFilterMask = EnumResultFilterSettings::TetraTmo_Supress_UserDefined_2; }
            }

            // Start printing
            __Mas_PduOpen_sprintf(g_pstrLayerTlSdsSndcpSs, L"MY-SDS-DATA");
            __Mas_PduText_RawLine();
            switch ( ucPID )
            {
                case   0: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Reserved\n", ucPID );                                          break;
                case   1: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> OTAK\n", ucPID );                                              break;
                case   2: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Simple Text Messaging\n", ucPID );                             break;
                case   3: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Simple location system\n", ucPID );                            break;
                case   4: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Wireless Datagram Protocol WAP\n", ucPID );                    break;
                case   5: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Wireless Control Message Protocol WCMP\n", ucPID );            break;
                case   6: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> M-DMO (Managed DMO)\n", ucPID );                               break;
                case   7: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> PIN authentication\n", ucPID );                                break;
                case   8: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> End-to-end encrypted message\n", ucPID );                      break;
                case   9: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Simple immediate text messaging\n", ucPID );                   break;
                case  10: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Location information protocol\n", ucPID );                     break;
                case  11: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Net Assist Protocol (NAP)\n", ucPID );                         break;
                case  12: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Concatenated SDS message\n", ucPID );                          break;
                case  13: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> DOTAM\n", ucPID );                                             break;

                case  64: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Teltronic\n", ucPID );                                         break;
                case  65: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Nokia\n", ucPID );                                             break;
                case  66: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Thales\n", ucPID );                                            break;
                case  67: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Tetra MoU\n", ucPID );                                         break;
                case  68: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> R&S Bick Mobilfunk GmbH\n", ucPID );                           break;
                case  69: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> R&S Bick Mobilfunk GmbH\n", ucPID );                           break;
                case  70: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> EADS Secure Networks Oy\n", ucPID );                           break;
                case  71: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Funkwerk Security Communications GmbH\n", ucPID );             break;
                case  72: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Indagon\n", ucPID );                                           break;
                case  73: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Thorcom Systems Ltd\n", ucPID );                               break;
                case  74: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> PMR-R&D GmbH\n", ucPID );                                      break;
                case  75: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> CECCLI\n", ucPID );                                            break;
                case  76: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Hytera Communications Corporation Limited\n", ucPID );         break;
                case  77: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Hytera Communications Corporation Limited\n", ucPID );         break;
                case  78: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Hytera Communications Corporation Limited\n", ucPID );         break;
                case  79: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Hytera Communications Corporation Limited\n", ucPID );         break;
                case  80: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Rheinmetall defence GmbH\n", ucPID );                          break;
                case  81: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Federal Agency for Public Safety Radio (BDBOS)\n", ucPID );    break;
                case  82: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Gina\n", ucPID );                                              break;
                case 127: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Reserved for extension\n", ucPID );                            break;

                case 130: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Text Messaging\n", ucPID );                                    break;
                case 131: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Location system\n", ucPID );                                   break;
                case 132: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Wireless Datagram Protocol WAP\n", ucPID );                    break;
                case 133: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Wireless Control Message Protocol WCMP\n", ucPID );            break;
                case 134: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> M-DMO (Managed DMO)\n", ucPID );                               break;
                case 135: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Reserved for future standard definition\n", ucPID );           break;
                case 136: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> End-to-end encrypted message\n", ucPID );                      break;
                case 137: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Immediate text messaging\n", ucPID );                          break;
                case 138: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Message with User Data Header\n", ucPID );                     break;
                case 139: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Reserved for future standard definition\n", ucPID );           break;
                case 140: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Concatenated SDS message\n", ucPID );                          break;

                case 192: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Teltronic\n", ucPID );                                         break;
                case 193: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Tetra Mou: TTR001-17 Radio User Assignment (RUA)\n", ucPID );  break;
                case 194: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> EADS Secure Networks Oy\n", ucPID );                           break;
                case 195: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Tetra Association: TTR 001-21: Callout\n", ucPID );            break;
                case 196: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Funkwerk Security Communications GmbH\n", ucPID );             break;
                case 197: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Airwave Solutions Ltd\n", ucPID );                             break;
                case 198: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> APD Communications Ltd\n", ucPID );                            break;
                case 199: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Airwave Solutions Ltd\n", ucPID );                             break;
                case 200: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Sepura ltd\n", ucPID );                                        break;
                case 201: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Sepura ltd\n", ucPID );                                        break;
                case 202: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Indagon Oy\n", ucPID );                                        break;
                case 203: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Directorate for Emergency Communication\n", ucPID );           break;
                case 204: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Federal Agency for Public Safety Radio (BDBOS)\n", ucPID );    break;
                case 208: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Rheinmetall defence GmbH\n", ucPID );                          break;
                case 210: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Sepura ltd\n", ucPID );                                        break;
                case 211: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Sepura ltd\n", ucPID );                                        break;
                case 220: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Motorola AS\n", ucPID );                                       break;
                case 221: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Motorola AS\n", ucPID );                                       break;
                case 222: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Motorola AS\n", ucPID );                                       break;
                case 223: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Motorola AS\n", ucPID );                                       break;
                case 224: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Motorola AS\n", ucPID );                                       break;
                case 225: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> TERRAFIX Ltd\n", ucPID );                                      break;
                case 226: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> TERRAFIX Ltd\n", ucPID );                                      break;
                case 227: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> TERRAFIX Ltd\n", ucPID );                                      break;
                case 230: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Motorola AS\n", ucPID );                                       break;
                case 231: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Hytera Communications Corporation Limited\n", ucPID );         break;
                case 232: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Hytera Communications Corporation Limited\n", ucPID );         break;
                case 236: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Sepura plc\n", ucPID );                                        break;
                case 237: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> 3tc Software Ltd\n", ucPID );                                  break;
                case 238: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> 3tc Software Ltd\n", ucPID );                                  break;
                case 240: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Motorola AS\n", ucPID );                                       break;
                case 244: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Thorcom Systems Ltd.\n", ucPID );                              break;
                case 250: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Thales UK LTD\n", ucPID );                                     break;
                case 255: __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Reserved for extension\n", ucPID );                            break;

                default:
                if ( 63 >= ucPID )
                {   __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Reserved for future standard definition\n", ucPID );     }
                if ( 126 >= ucPID )
                {   __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Available for user application definition\n", ucPID );   }
                if ( 129 >= ucPID )
                {   __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Reserved\n", ucPID );                                    }
                else
                    if ( 191 >= ucPID )
                    {   __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Reserved for future standard definition\n", ucPID ); }
                if ( 254 >= ucPID )
                {   __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Available for user application definition\n", ucPID );   }
                else
                {   __Mas_PduText_sprintf( L"Protocol identifier: %2.2u -> Reserved\n", ucPID );    }
                break;
            } // switch ( ucPID )

              // Print hexadecimal data
            const unsigned int ulByteLength = __Sec_Min( (sizeof((__MSGDATA_POINTER)->ucData) << 3), __Sec_Max(1, (((__MSGDATA_POINTER)->ulDataLength+7) >> 3))-1 ); // Convert into bytes (after PID byte)
            if ( ulByteLength )
            {   // Dump data
                __Mas_PduText_sprintf( L"Dump data: %u bits (%u bytes)\n", ((__MSGDATA_POINTER)->ulDataLength-__MAS_READ_INDEX), ulByteLength );
                // Dump data
                __Mas_PduText_HexBinAsc((__MSGDATA_POINTER)->ucData, ulByteLength);
            }
            __Mas_PduCose();

        }// ---------------------------------------------------------------------------------------------------------------------                                       // Analyse content of data from wanted PID      ulType: PID                         , ulExtendedType: -
        break;

        case ThirdPartyComponent5V_Sndcp_Pdu:           // Analyse registred PDU* NOTE1                 ulType: SNDCP-PDU Type              , ulExtendedType: -
        case ThirdPartyComponent5V_Sndcp_Pdu_Unknown:   // Analyse not known PDU by analysis            ulType: -                           , ulExtendedType: -
        {   // ---------------------------------------------------------------------------------------------------------------------
            __Mas_PduOpen_sprintf(g_pstrLayerTlSdsSndcpSs_MmCmce, L"MY-SNDCP-PDU" );
            __Mas_PduText_RawLine();

            // Print hexadecimal data
            const unsigned int ulByteLength = __Sec_Min( (sizeof((__MSGDATA_POINTER)->ucData) << 3), (((__MSGDATA_POINTER)->ulDataLength+7) >> 3) ); // Convert into bytes
            if ( ulByteLength )
            {   // Dump data
                __Mas_PduText_sprintf( L"Dump data: %u bits (%u bytes)\n",  ((__MSGDATA_POINTER)->ulDataLength), ulByteLength );
                __Mas_PduText_HexBinAsc((__MSGDATA_POINTER)->ucData, ulByteLength );
            }
            __Mas_PduCose();
        }   // ---------------------------------------------------------------------------------------------------------------------
        break;

        case ThirdPartyComponent5V_Sndcp_Content:       // Analyse content of data from SNDCP-DATA PDU  ulType: - * NOTE5                   , ulExtendedType: -
        {   // ---------------------------------------------------------------------------------------------------------------------
            __Mas_PduOpen_sprintf(g_pstrLayerTlSdsSndcpSs_MmCmce, L"MY-IP-DATA" );
            __Mas_PduText_RawLine();

            __Mas_PduText_sprintf( L"Full IP data:\n" );
            // Can print hexadecimal data?
            const unsigned int ulByteLength = __Sec_Min( (sizeof((__MSGDATA_POINTER)->ucData) << 3), (((__MSGDATA_POINTER)->ulDataLength+7) >> 3) );
            if ( ulByteLength )
            {   // Dump data
                __Mas_PduText_sprintf( L"Dump data: %u bits (%u bytes)\n", ((__MSGDATA_POINTER)->ulDataLength), ulByteLength );
                __Mas_PduText_HexBinAsc((__MSGDATA_POINTER)->ucData, ulByteLength );
            }
            __Mas_PduCose();
        }   // ---------------------------------------------------------------------------------------------------------------------
        break;

        case ThirdPartyComponent5V_Ss_Pdu:              // Analyse registred PDU,* NOTE1                ulType: D/U-FACILITY: SS type       , ulExtendedType[0]: SS-PDU type(0xFFFFFFFF=ALL)
        case ThirdPartyComponent5V_Ss_Pdu_Unknown:      // Analyse not known PDU by analysis            ulType: -                           , ulExtendedType: -
        {   // ---------------------------------------------------------------------------------------------------------------------
            __Mas_PduOpen_sprintf( g_pstrLayerTlSdsSndcpSs, L"MY-SS-PDU" );
            __Mas_PduText_RawLine();

            // Print hexadecimal data
            const unsigned int ulByteLength = __Sec_Min( (sizeof((__MSGDATA_POINTER)->ucData) << 3), (((__MSGDATA_POINTER)->ulDataLength+7) >> 3) ); // Convert into bytes
            if ( ulByteLength )
            {   // Dump data
                __Mas_PduText_sprintf( L"Dump data: %u bits (%u bytes)\n",  ((__MSGDATA_POINTER)->ulDataLength), ulByteLength );
                __Mas_PduText_HexBinAsc((__MSGDATA_POINTER)->ucData, ulByteLength );
            }
            __Mas_PduCose();
        }   // ---------------------------------------------------------------------------------------------------------------------
        break;

        default:
        {   // ---------------------------------------------------------------------------------------------------------------------
            __Mas_PduOpen_sprintf( g_pstrLayerTlSdsSndcpSs, L"MY-UNKNOWN" );
            __Mas_PduText_RawLine();

            // Print hexadecimal data
            const unsigned int ulByteLength = __Sec_Min( (sizeof((__MSGDATA_POINTER)->ucData) << 3), (((__MSGDATA_POINTER)->ulDataLength+7) >> 3) ); // Convert into bytes
            if ( ulByteLength )
            {   // Dump data
                __Mas_PduText_sprintf( L"Dump data: %u bits (%u bytes)\n",  ((__MSGDATA_POINTER)->ulDataLength), ulByteLength );
                __Mas_PduText_HexBinAsc((__MSGDATA_POINTER)->ucData, ulByteLength );
            }
            __Mas_PduCose();
        }   // ---------------------------------------------------------------------------------------------------------------------
        break;
    } // switch ( (__MSGDATA_POINTER)->eRegisterType )

    // Result in "pstAnalyseResult" stored
    return 0;
}

// Called if no further data will be analysed
THIRD_PARTY_COMPONENT_5V int ThirdPartyComponent5V_Close(void *pDllInstance)
{
    // Nothing todo yet
    return 0;
}
