/*
* Zero-Clause BSD
*
* Permission to use, copy, modify, and/or distribute this software for any purpose with or without fee is hereby granted.
*
* THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
* NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
*/

#ifndef _THIRD_PARTY_COMPONENT_5V_H
#define _THIRD_PARTY_COMPONENT_5V_H

#if (defined _WINDOWS) || (defined WIN32) || (defined WIN64)
    #include <windows.h>        // HMODULE, LoadLibrary(), FreeLibrary(), __declspec()
#endif
#include <wchar.h>              // wchar_t

#ifdef  __cplusplus
extern "C" {
#endif

#if (defined _WINDOWS) || (defined WIN32) || (defined WIN64)
    #ifdef THIRD_PARTY_COMPONENT_5V_EXPORTS
        // For exporting DLL functions
        #define THIRD_PARTY_COMPONENT_5V __declspec(dllexport)
    #else
        // For importing DLL functions
        #define THIRD_PARTY_COMPONENT_5V __declspec(dllimport)
    #endif
#else  // (defined _WINDOWS) || (defined WIN32) || (defined WIN64)
    #ifdef THIRD_PARTY_COMPONENT_5V_EXPORTS
        // For exporting DLL functions
        #define THIRD_PARTY_COMPONENT_5V export
    #else
        // For importing DLL functions
        #define THIRD_PARTY_COMPONENT_5V import
    #endif
#endif // (defined _WINDOWS) || (defined WIN32) || (defined WIN64)
// ------------------------------------------------------------------------------------------------------------------------
// ------------------------------------------------------------------------------------------------------------------------
// ------------------------------------------------------------------------------------------------------------------------
// Init DLL, register content for third party analysing
typedef enum EnumThirdPartyComponent5V_Protokoll : unsigned int
{
    ThirdPartyComponent5V_TetraTmo  = (1 << 0), // TETRA messages
    ThirdPartyComponent5V_TetraDmo  = (1 << 1), // TETRA-DMO messages
    ThirdPartyComponent5V_Dmr       = (1 << 2)  // DMR messages
} EnumThirdPartyComponent5V_Protokoll;

// Content definition for third party analysing
typedef enum EnumThirdPartyComponent5V_RegType : unsigned int
{
    // -----------------------------------------------------------------------------------------
    // Data for "ThirdPartyComponent5V_TetraTmo", number range: er 0-999
    ThirdPartyComponent5V_TETRA_Start = 0,                          // Helper for counting analyse types
    //------
    ThirdPartyComponent5V_UMac_TCH = ThirdPartyComponent5V_TETRA_Start, // Analyse speech on TCH channel                ulType: -                           , ulExtendedType: - (No airinterface decryption and circuit mode for now)
    ThirdPartyComponent5V_UMac_UPlane,                                  // Analyse UPlane-Stealing on TCH channel       ulType: -                           , ulExtendedType: - (No airinterface decryption and circuit mode for now)
    ThirdPartyComponent5V_UMac_Pdu,                                     // Analyse registred PDU* NOTE1                 ulType: UMac-PDU Type* NOTE2        , ulExtendedType: -  or "MAC-FRAG, MAC-END, D/U-BLCK" (0xFFFFFFFF=ALL)
    ThirdPartyComponent5V_UMac_Unknown,                                 // Analyse not known PDU by analysis            ulType: -                           , ulExtendedType: -

    ThirdPartyComponent5V_Llc_Pdu,                                      // Analyse registred PDU* NOTE1                 ulType: LLC-PDU Type                , ulExtendedType: - or "AL-X-*, L2-SIGNAL-*" (0xFFFFFFFF=ALL)
    ThirdPartyComponent5V_Llc_Pdu_Unknown,                              // Analyse not known PDU by analysis            ulType: -                           , ulExtendedType: -

    ThirdPartyComponent5V_Mle_Pdu,                                      // Analyse registred PDU* NOTE1                 ulType: MLE-PDU Type * NOTE3        , ulExtendedType: -
    ThirdPartyComponent5V_Mle_Pdu_Unknown,                              // Analyse not known PDU by analysis            ulType: -                           , ulExtendedType: -
    ThirdPartyComponent5V_Mle_ProtocolDiscriminator,                    // Analyse registred layer                      ulType: MLE Protocol discriminator  , ulExtendedType: -

    ThirdPartyComponent5V_Mm_Pdu,                                       // Analyse registred PDU* NOTE1                 ulType: MM-PDU Type                 , ulExtendedType: - or "U/D-AUTHENTICATION, U/D-OTAR,..." (0xFFFFFFFF=ALL)
    ThirdPartyComponent5V_Mm_Pdu_Unknown,                               // Analyse not known PDU by analysis            ulType: -                           , ulExtendedType: -
    ThirdPartyComponent5V_Mm_Element_Type34,                            // Not yet supported

    ThirdPartyComponent5V_Cmce_Pdu,                                     // Analyse registred PDU* NOTE1                 ulType: CMCE-PDU Type               , ulExtendedType: -
    ThirdPartyComponent5V_Cmce_Pdu_Unknown,                             // Analyse not known PDU by analysis            ulType: -                           , ulExtendedType: -
    ThirdPartyComponent5V_Cmce_Element_Type34,                          // Not yet supported

    ThirdPartyComponent5V_SdsStatus_Content,                            // Analyse content of data                      ulType: -                           , ulExtendedType: -
    ThirdPartyComponent5V_SdsType1_Content,                             // Analyse content of data:                     ulType: -                           , ulExtendedType: -
    ThirdPartyComponent5V_SdsType2_Content,                             // Analyse content of data                      ulType: -                           , ulExtendedType: -
    ThirdPartyComponent5V_SdsType3_Content,                             // Analyse content of data                      ulType: -                           , ulExtendedType: -
    ThirdPartyComponent5V_SdsType4_Content_All,                         // Analyse content of data (TL/No TL)           ulType: -                           , ulExtendedType: -
    ThirdPartyComponent5V_SdsType4_Content_NoTL,                        // Analyse content of data (only no TL)         ulType: -                           , ulExtendedType: -
    ThirdPartyComponent5V_SdsType4_Content_TL,                          // Analyse content of data (only TL)            ulType: - * NOTE4                   , ulExtendedType: -
    ThirdPartyComponent5V_SdsType4_PID,                                 // Analyse content of data from wanted PID      ulType: PID                         , ulExtendedType: -

    ThirdPartyComponent5V_Sndcp_Pdu,                                    // Analyse registred PDU* NOTE1                 ulType: SNDCP-PDU Type              , ulExtendedType: -
    ThirdPartyComponent5V_Sndcp_Pdu_Unknown,                            // Analyse not known PDU by analysis            ulType: -                           , ulExtendedType: -
    ThirdPartyComponent5V_Sndcp_Element_Type34,                         // Not yet supported
    ThirdPartyComponent5V_Sndcp_Content,                                // Analyse content of data from SNDCP-DATA PDU  ulType: - * NOTE5                   , ulExtendedType: -

    ThirdPartyComponent5V_Ss_Pdu,                                       // Analyse registred PDU,* NOTE1                ulType: D/U-FACILITY: SS type       , ulExtendedType[0]: SS-PDU type(0xFFFFFFFF=ALL)
    ThirdPartyComponent5V_Ss_Pdu_Unknown,                               // Analyse not known PDU by analysis            ulType: -                           , ulExtendedType: -
    ThirdPartyComponent5V_Ss_Element_Type34,                            // Not yet supported
    //------
    ThirdPartyComponent5V_TETRA_End,                                    // Helper for counting analyse types
    // -----------------------------------------------------------------------------------------

    // -----------------------------------------------------------------------------------------
    // Data for "ThirdPartyComponent5V_TetraDmo", number range: er 1000-1999
    ThirdPartyComponent5V_TETRADMO_Start = 1000,                    // Helper for counting analyse types
    //------
    // Not yet implemented
    //------
    ThirdPartyComponent5V_TETRADMO_End,                             // Helper for counting analyse types
    // -----------------------------------------------------------------------------------------

    // -----------------------------------------------------------------------------------------
    // Data for "ThirdPartyComponent5V_Dmr", number range: er 2000-2999
    ThirdPartyComponent5V_DMR_Start = 2000,                         // Helper for counting analyse types
    //------
    // Not yet implemented
    //------
    ThirdPartyComponent5V_DMR_End                                   // Helper for counting analyse types
    // -----------------------------------------------------------------------------------------

    // NOTE1: Use value "0xFFFFFFFF" for all PDUs
    // NOTE2: for SCH/F, STCH, SCH/HD, BNCH (BNCH-Q, SCH-Q, SCH-Q) use exact 2 bit PDU-type value.
    //        for SCH/HU, SCH-Q/RA use: 0x00000100=MAC-ACCESS, 0x00000101=MAC-END-HU
    //        for BSCH use: 0x00000200 (Sync)
    // NOTE3: For BSCH use: 0x00000200 (Sync), 0x00000201 (Sysinfo)
    // NOTE4: Not allowed to set but the resulting PID will be set in "StructThirdPartyComponent5V_Data::ulType".
    // NOTE5: Not allowed to set but the resulting NSAPI, DCOMP, PCOMP set in "StructThirdPartyComponent5V_Data::ulType, ulExtendedType[0,1]".
} EnumThirdPartyComponent5V_RegType;

// Register command for data
typedef struct StructThirdPartyComponent5V_RegData
{
    // Type of registred message
    EnumThirdPartyComponent5V_RegType   eRegisterType;

    // Direction is need to be set for all:
    unsigned int                        ulDirection;    // 0=Disabled, 0x01=Downlink, 0x02=Uplink, 0x03=Both
    // Registered data:
    // *_ProtocolDiscriminator          : MLE-Protocol Discriminator
    // *_Pdu                            : PDU-Type (first part if splitted into 'PDU type' and 'PDU type extension')
    // *_PID                            : SDS Protocol identifier
    // *_Content, *_Proprietary         : No meaning
    unsigned int                        ulType;
    // *_Pdu                            : Extended PDU: If PDU type is splitted in two parts like 'PDU type' and 'PDU type extension'
    // other                            : No meaning
    unsigned int                        ulExtendedType[2];
} StructThirdPartyComponent5V_RegData;

#define STRUCT_THIRDPARTYCOMPONENT5V_INIT__VERSION  (1)
typedef struct StructThirdPartyComponent5V_Init
{
    // Version of this structure
    unsigned int                        ulVersion;  // 1

    // Supported Protokoll, which type of protokoll data is supported (EnumThirdPartyComponent5V_Protokoll)
    unsigned int                        ulProtokollSupport;

    // Version/Company/Copyright string
    char                                strVersion[128];

    // Not used by the MultiAnalyzer, calling further function contains the pointer
    void                                *pDllInstance;

    // All registred data
    unsigned int                        ulRegisterCount;
    StructThirdPartyComponent5V_RegData stRegisterData[128];
} StructThirdPartyComponent5V_Init;

// Helper macros for init
#define ThirdPartyComponent5V_RegData               {ThirdPartyComponent5V_TETRA_Start,0,0,{0,0}}
#define ThirdPartyComponent5V_RegData_All           ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,\
                                                    ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,\
                                                    ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,\
                                                    ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,\
                                                    ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,\
                                                    ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,\
                                                    ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,\
                                                    ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData,ThirdPartyComponent5V_RegData
#define ThirdPartyComponent5V_InitV1(nVersion)      { nVersion, 0, { 0 }, NULL, 0, { ThirdPartyComponent5V_RegData_All } }
// Last version: STRUCT_THIRDPARTYCOMPONENT5V_INIT__VERSION
#define ThirdPartyComponent5V_InitV                 ThirdPartyComponent5V_InitV1
#define StructThirdPartyComponent5V_InitV           StructThirdPartyComponent5V_Init

// DLL provides wanted types of data for it own analysing...
// Returns 0: If successfull, all other values marking an error
THIRD_PARTY_COMPONENT_5V int ThirdPartyComponent5V_Init(        StructThirdPartyComponent5V_Init * );
typedef                  int(*func_ThirdPartyComponent5V_Init)( StructThirdPartyComponent5V_Init * );
// ------------------------------------------------------------------------------------------------------------------------
// ------------------------------------------------------------------------------------------------------------------------
// ------------------------------------------------------------------------------------------------------------------------


// ------------------------------------------------------------------------------------------------------------------------
// ------------------------------------------------------------------------------------------------------------------------
// ------------------------------------------------------------------------------------------------------------------------
typedef enum EnumThirdPartyComponent5V_Channel : unsigned int
{
    ThirdPartyComponent5V_Channel_Idle,             // Unknown
    ThirdPartyComponent5V_Channel_Control,          // Control channel                      (TETRA: CCCH)
    ThirdPartyComponent5V_Channel_Traffic,          // Active speach on traffic channel     (TETRA: TCH)
    ThirdPartyComponent5V_Channel_Traffic_Control,  // Control channel on traffic channel   (TETRA: SACCH)
    ThirdPartyComponent5V_Channel_Traffic_Idle,     // No active speach on traffic channel  (TETRA: FACCH)
    ThirdPartyComponent5V_Channel_Data              // Data channel                         (TETRA: PDCH)
} EnumThirdPartyComponent5V_Channel;

typedef enum EnumThirdPartyComponent5V_Address  : unsigned int
{
    ThirdPartyComponent5V_Address_NotPresent,       // Unknown
    ThirdPartyComponent5V_Address_Normal,           // Normal address type                  (TETRA: SSI)
    ThirdPartyComponent5V_Address_Temporary,        // Temporary address type               (TETRA: USSI)
    ThirdPartyComponent5V_Address_Short             // Short address type                   (TETRA: Eventlable)
} EnumThirdPartyComponent5V_Address;

typedef enum EnumThirdPartyComponent5V_Result   : unsigned int
{
    ThirdPartyComponent5V_Result_Nothing,           // Do nothing, print own analysis as normal, if add own analysis... (add own filter)
    ThirdPartyComponent5V_Result_NothingButFilter,  // Do nothing, print own analysis as normal, if add own analysis... (replace with own filter)
    ThirdPartyComponent5V_Result_AnalyseContent ,   // ulAnalyseLength,ucAnalyse is filled, analyse and print it instead of original data as SDS-DATA(-TL), SNDCP, TCH/UPlane content (i.e. after E2E decryption). (add own filter)
    ThirdPartyComponent5V_Result_Supress,           // Supress printing own analyse, because data is already analysed and printed. (replace with own filter)
    ThirdPartyComponent5V_Result_SupressFull        // Supress printing own analyse for this and all follow layer, data is already analysed and printed. (replace with own filter)
} EnumThirdPartyComponent5V_Result;


// Helper to add text from external analyse DLL
// Need to be used for: *_TCH, *_UPlane, *_ProtocolDiscriminator, *_Pdu, *_Unknown, *_Content*, *_PID
typedef int(*func_ThirdPartyComponent5V_PduOpen       )(const wchar_t *, const wchar_t *, void *); // Open an stand alone PDU
typedef int(*func_ThirdPartyComponent5V_PduAddText    )(const wchar_t *                 , void *); // Add text to a stand alone PDU
typedef int(*func_ThirdPartyComponent5V_PduClose      )(                                  void *); // Close a stand alone PDU
// Need to be used for: *_Proprietary
typedef int(*func_ThirdPartyComponent5V_ElementAddText)(const wchar_t *                 , void *); // Add text for an element

#define STRUCT_THIRDPARTYCOMPONENT5V_DATA__VERSION_V1  (1)
typedef struct StructThirdPartyComponent5V_Data
{
    // Version of this structure
    unsigned int                        ulVersion;  // STRUCT_THIRDPARTYCOMPONENT5V_DATA__VERSION_V1

    // ----------------------------------------------------------------------------------------------------------------------------
    // Similar to registerd message (StructThirdPartyComponent5V_RegData):
    // Type of registred message
    EnumThirdPartyComponent5V_RegType   eRegisterType;
    // Unique direction is need to be set for all:
    unsigned int                        ulDirection;    // 0x01=Downlink, 0x02=Uplink
    // Registered data:
    // *_ProtocolDiscriminator          : MLE-Protocol Discriminator
    // *_Pdu                            : PDU-Type (first part if splitted into 'PDU type' and 'PDU type extension')
    // *_PID                            : SDS Protocol identifier
    // *_Content, *_Proprietary         : No meaning
    unsigned int                        ulType;
    // *_Pdu                            : Extended PDU: If PDU type is splitted in two parts like 'PDU type' and 'PDU type extension'
    // other                            : No meaning
    unsigned int                        ulExtendedType[2];
    // ----------------------------------------------------------------------------------------------------------------------------

    // ----------------------------------------------------------------------------------------------------------------------------
    // Extra information:
    // Frame information
    unsigned int                        ulFrame[4];     // For TETRA: [0]=Hyperframe, [1]=MultiFrame, [2]=Frame, [3]=Slot
    // Time information
    unsigned long long                  ullTime;        // Format: __time64_t
    unsigned int                        ulMilliSeconds; // 0...999
    // Current channel status:
    EnumThirdPartyComponent5V_Channel   eChannel;
    // Current cell information
    // For TETRA: [0]=Channel-Number, [1]=CC, [2]=Mcc, [3]=Mnc, [4]=LA, [5,6,7]=Reserverd
    unsigned int                        ulCellData[8];
    // If running call, the current call data: (element order not yet defined)
    unsigned int                        ulSpeechData[16];
    // If known orginater:
    EnumThirdPartyComponent5V_Address   eOrginatorAddressType;
    unsigned int                        ulOrginatorAddress;
    // If known terminator:
    EnumThirdPartyComponent5V_Address   eTerminatorAddressType;
    unsigned int                        ulTerminatorAddress;
    // Filter information (Is protocoll filter option for this message set?)
    unsigned long long                  ullFilterMask;
    // ----------------------------------------------------------------------------------------------------------------------------

    // ----------------------------------------------------------------------------------------------------------------------------
    // Provides callback functions for adding data into result file...
    void *pInternalParameter; // Never change, commint to function as last argument
    func_ThirdPartyComponent5V_PduOpen          callback_PduOpen;
    func_ThirdPartyComponent5V_PduClose         callback_PduClose;
    func_ThirdPartyComponent5V_PduAddText       callback_PduAddText;
    func_ThirdPartyComponent5V_ElementAddText   callback_ElementAddText; // Not yet used
    // ----------------------------------------------------------------------------------------------------------------------------

    // ----------------------------------------------------------------------------------------------------------------------------
    // Data or registred message
    unsigned int                        ulDataLength;
    unsigned char                       ucData[4096];
    // ----------------------------------------------------------------------------------------------------------------------------
} StructThirdPartyComponent5V_Data;

#define STRUCT_THIRDPARTYCOMPONENT5V_DATA__VERSION_V2   (2)
typedef struct StructThirdPartyComponent5V_DataV2
{
    // ----------------------------------------------------------------------------------------------------------------------------
    // Identical V1 data:
        // Version of this structure
        unsigned int                        ulVersion;  // STRUCT_THIRDPARTYCOMPONENT5V_DATA__VERSION_V2

        // ----------------------------------------------------------------------------------------------------------------------------
        // Similar to registerd message (StructThirdPartyComponent5V_RegData):
        // Type of registred message
        EnumThirdPartyComponent5V_RegType   eRegisterType;
        // Unique direction is need to be set for all:
        unsigned int                        ulDirection;    // 0x01=Downlink, 0x02=Uplink
        // Registered data:
        // *_ProtocolDiscriminator          : MLE-Protocol Discriminator
        // *_Pdu                            : PDU-Type (first part if splitted into 'PDU type' and 'PDU type extension')
        // *_PID                            : SDS Protocol identifier
        // *_Content, *_Proprietary         : No meaning
        unsigned int                        ulType;
        // *_Pdu                            : Extended PDU: If PDU type is splitted in two parts like 'PDU type' and 'PDU type extension'
        // other                            : No meaning
        unsigned int                        ulExtendedType[2];
        // ----------------------------------------------------------------------------------------------------------------------------

        // ----------------------------------------------------------------------------------------------------------------------------
        // Extra information:
        // Frame information
        unsigned int                        ulFrame[4];     // For TETRA: [0]=Hyperframe, [1]=MultiFrame, [2]=Frame, [3]=Slot
        // Time information
        unsigned long long                  ullTime;        // Format: __time64_t
        unsigned int                        ulMilliSeconds; // 0...999
        // Current channel status:
        EnumThirdPartyComponent5V_Channel   eChannel;
        // Current cell information
        // For TETRA: [0]=Channel-Number, [1]=CC, [2]=Mcc, [3]=Mnc, [4]=LA, [5,6,7]=Reserverd
        unsigned int                        ulCellData[8];
        // If running call, the current call data: (element order not yet defined)
        unsigned int                        ulSpeechData[16];
        // If known orginater:
        EnumThirdPartyComponent5V_Address   eOrginatorAddressType;
        unsigned int                        ulOrginatorAddress;
        // If known terminator:
        EnumThirdPartyComponent5V_Address   eTerminatorAddressType;
        unsigned int                        ulTerminatorAddress;
        // Filter information (Is protocoll filter option for this message set?)
        unsigned long long                  ullFilterMask;
        // ----------------------------------------------------------------------------------------------------------------------------

        // ----------------------------------------------------------------------------------------------------------------------------
        // Provides callback functions for adding data into result file...
        void *pInternalParameter; // Never change, commint to function as last argument
        func_ThirdPartyComponent5V_PduOpen          callback_PduOpen;
        func_ThirdPartyComponent5V_PduClose         callback_PduClose;
        func_ThirdPartyComponent5V_PduAddText       callback_PduAddText;
        func_ThirdPartyComponent5V_ElementAddText   callback_ElementAddText; // Not yet used
        // ----------------------------------------------------------------------------------------------------------------------------

        // ----------------------------------------------------------------------------------------------------------------------------
        // Data or registred message
        unsigned int                        ulDataLength;
        unsigned char                       ucData[4096];
        // ----------------------------------------------------------------------------------------------------------------------------
    // ----------------------------------------------------------------------------------------------------------------------------

    // ----------------------------------------------------------------------------------------------------------------------------
    // V2 data:
    const wchar_t   *pstrCurrentMafFileName;    // current name of MAF file
    bool             bNewMafFile;               // MAF-File changed since last call
    // ----------------------------------------------------------------------------------------------------------------------------
} StructThirdPartyComponent5V_DataV2;
// Last current data
#define STRUCT_THIRDPARTYCOMPONENT5V_DATA__VERSION      (STRUCT_THIRDPARTYCOMPONENT5V_DATA__VERSION_V2)
#define StructThirdPartyComponent5V_DataV               StructThirdPartyComponent5V_DataV2

#define STRUCT_THIRDPARTYCOMPONENT5V_RESULT__VERSION    (1)
typedef struct StructThirdPartyComponent5V_Result
{
    // Version of this structure
    unsigned int                        ulVersion;  // STRUCT_THIRDPARTYCOMPONENT5V_RESULT__VERSION

    // Something special todo?
    EnumThirdPartyComponent5V_Result    eResult;
    // Allow to filter this message, set corresponding bitmask, 0=no filter show always.
    unsigned long long                  ullFilterMask;
    // If wanted add the message as follow user define message type, used in QoS analyse:
    // 0=None; 1...N: Use this user defined message type
    unsigned int                        ulMsgType;

    // Analyse follow data as in eResult defined:
    unsigned int                        ulAnalyseLength;
    unsigned char                       ucAnalyse[4096];
} StructThirdPartyComponent5V_Result;

// Multianalyser provides data for analysing:
// Input : StructThirdPartyComponent5V_Data  : The data themself for external analysing
// Output: StructThirdPartyComponent5V_Result: What is todo for multianalyser.
// Returns 0: Result is stored in StructThirdPartyComponent5V_Result, all other values are errors
THIRD_PARTY_COMPONENT_5V int ThirdPartyComponent5V_Data(        void *, const StructThirdPartyComponent5V_Data *, StructThirdPartyComponent5V_Result *);
typedef                  int(*func_ThirdPartyComponent5V_Data)( void *, const StructThirdPartyComponent5V_Data *, StructThirdPartyComponent5V_Result *);
// ------------------------------------------------------------------------------------------------------------------------
// ------------------------------------------------------------------------------------------------------------------------
// ------------------------------------------------------------------------------------------------------------------------



// ------------------------------------------------------------------------------------------------------------------------
// ------------------------------------------------------------------------------------------------------------------------
// ------------------------------------------------------------------------------------------------------------------------
// Called if no further data will be analysed
THIRD_PARTY_COMPONENT_5V int ThirdPartyComponent5V_Close(       void * );
typedef                  int(*func_ThirdPartyComponent5V_Close)(void * );
// ------------------------------------------------------------------------------------------------------------------------
// ------------------------------------------------------------------------------------------------------------------------
// ------------------------------------------------------------------------------------------------------------------------


// ------------------------------------------------------------------------------------------------------------------------
// ------------------------------------------------------------------------------------------------------------------------
// ------------------------------------------------------------------------------------------------------------------------
#if (defined _WINDOWS) || (defined WIN32) || (defined WIN64)
    // Help macros for loading DLL dynamicly
    typedef struct StructThirdPartyComponent5V_Dll
    {
        HMODULE                             hComponentDll;
        func_ThirdPartyComponent5V_Init     ThirdPartyComponent5V_Init;
        func_ThirdPartyComponent5V_Data     ThirdPartyComponent5V_Data;
        func_ThirdPartyComponent5V_Close    ThirdPartyComponent5V_Close;
    } StructThirdPartyComponent5V_Dll;

    #define ThirdPartyComponent5__LoadDLL( sComponentDll, nLoadFlag, sPathNameDll )\
            memset( &(sComponentDll)        , 0, sizeof(sComponentDll) );\
            nLoadFlag                       = FALSE;\
            (sComponentDll).hComponentDll   = ::LoadLibrary( sPathNameDll );\
            if ( (sComponentDll).hComponentDll )\
            {\
                (sComponentDll).ThirdPartyComponent5V_Init  = (func_ThirdPartyComponent5V_Init )::GetProcAddress( (sComponentDll).hComponentDll, "ThirdPartyComponent5V_Init" ); nLoadFlag |= !( (sComponentDll).ThirdPartyComponent5V_Init );\
                (sComponentDll).ThirdPartyComponent5V_Data  = (func_ThirdPartyComponent5V_Data )::GetProcAddress( (sComponentDll).hComponentDll, "ThirdPartyComponent5V_Data" ); nLoadFlag |= !( (sComponentDll).ThirdPartyComponent5V_Data );\
                (sComponentDll).ThirdPartyComponent5V_Close = (func_ThirdPartyComponent5V_Close)::GetProcAddress( (sComponentDll).hComponentDll, "ThirdPartyComponent5V_Close"); nLoadFlag |= !( (sComponentDll).ThirdPartyComponent5V_Close);\
            }\
            else\
                nLoadFlag = TRUE

    #define ThirdPartyComponent5__UnLoadDLL( sComponentDll )\
            if ( (sComponentDll).hComponentDll )\
            {   (void)::FreeLibrary( (sComponentDll).hComponentDll ); }\
            memset( &(sComponentDll), 0, sizeof(sComponentDll) )
#endif // (defined _WINDOWS) || (defined WIN32) || (defined WIN64)
// ------------------------------------------------------------------------------------------------------------------------
// ------------------------------------------------------------------------------------------------------------------------
// ------------------------------------------------------------------------------------------------------------------------

#ifdef  __cplusplus
}
#endif

#endif // _THIRD_PARTY_COMPONENT_5V_H

